/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.trender.gui.client;

import dev.tr7zw.transition.mc.ComponentProvider;
import dev.tr7zw.trender.gui.GuiDescription;
import dev.tr7zw.trender.gui.client.LibGui;
import dev.tr7zw.trender.gui.client.RenderContext;
import dev.tr7zw.trender.gui.client.Scissors;
import dev.tr7zw.trender.gui.client.ScreenDrawing;
import dev.tr7zw.trender.gui.impl.VisualLogger;
import dev.tr7zw.trender.gui.impl.client.CottonScreenImpl;
import dev.tr7zw.trender.gui.impl.client.FocusElements;
import dev.tr7zw.trender.gui.impl.client.MouseInputHandler;
import dev.tr7zw.trender.gui.impl.client.NarrationHelper;
import dev.tr7zw.trender.gui.impl.mixin.client.ScreenAccessor;
import dev.tr7zw.trender.gui.widget.WPanel;
import dev.tr7zw.trender.gui.widget.WWidget;
import dev.tr7zw.trender.gui.widget.data.InputResult;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class CottonClientScreen
extends class_437
implements CottonScreenImpl {
    private static final VisualLogger LOGGER = new VisualLogger(CottonClientScreen.class);
    protected GuiDescription description;
    protected int left = 0;
    protected int top = 0;
    protected int titleX;
    protected int titleY;
    @Nullable
    protected WWidget lastResponder = null;
    private final MouseInputHandler<CottonClientScreen> mouseInputHandler = new MouseInputHandler<CottonClientScreen>(this);

    public CottonClientScreen(GuiDescription description) {
        this(ComponentProvider.EMPTY, description);
    }

    public CottonClientScreen(class_2561 title, GuiDescription description) {
        super(title);
        this.description = description;
        description.getRootPanel().validate(description);
    }

    @Override
    public GuiDescription getDescription() {
        return this.description;
    }

    public void method_25426() {
        super.method_25426();
        WPanel root = this.description.getRootPanel();
        if (root != null) {
            root.addPainters();
        }
        this.description.addPainters();
        this.reposition(this.field_22789, this.field_22790);
        if (root != null) {
            FocusElements.PanelFocusElement rootPanelElement = FocusElements.ofPanel(root);
            ((ScreenAccessor)((Object)this)).libgui$getChildren().add(rootPanelElement);
            this.method_48265(rootPanelElement);
        } else {
            LOGGER.warn("No root panel found, keyboard navigation disabled", new Object[0]);
        }
    }

    public void method_25432() {
        super.method_25432();
        VisualLogger.reset();
    }

    @Override
    @Nullable
    public WWidget getLastResponder() {
        return this.lastResponder;
    }

    @Override
    public void setLastResponder(@Nullable WWidget lastResponder) {
        this.lastResponder = lastResponder;
    }

    protected void reposition(int screenWidth, int screenHeight) {
        WPanel root;
        if (this.description != null && (root = this.description.getRootPanel()) != null) {
            this.titleX = this.description.getTitlePos().x();
            this.titleY = this.description.getTitlePos().y();
            if (!this.description.isFullscreen()) {
                this.left = (screenWidth - root.getWidth()) / 2;
                this.top = (screenHeight - root.getHeight()) / 2;
            } else {
                this.left = 0;
                this.top = 0;
                root.setSize(screenWidth, screenHeight);
            }
        }
    }

    private void paint(RenderContext context, int mouseX, int mouseY, float delta) {
        if (this.description != null) {
            WPanel root = this.description.getRootPanel();
            if (root != null) {
                GL11.glEnable((int)3089);
                Scissors.refreshScissors();
                root.paint(context, this.left, this.top, mouseX - this.left, mouseY - this.top);
                GL11.glDisable((int)3089);
                Scissors.checkStackIsEmpty();
            }
            if (this.method_25440() != null && this.description.isTitleVisible()) {
                int width = this.description.getRootPanel().getWidth();
                if (LibGui.getGuiStyle().isFontShadow()) {
                    ScreenDrawing.drawStringWithShadow(context, this.method_25440().method_30937(), this.description.getTitleAlignment(), this.left + this.titleX, this.top + this.titleY, width - 2 * this.titleX, this.description.getTitleColor());
                } else {
                    ScreenDrawing.drawString(context, this.method_25440().method_30937(), this.description.getTitleAlignment(), this.left + this.titleX, this.top + this.titleY, width - 2 * this.titleX, this.description.getTitleColor());
                }
            }
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float partialTicks) {
        WWidget hitChild;
        WPanel root;
        super.method_25394(context, mouseX, mouseY, partialTicks);
        RenderContext renderContext = new RenderContext(context);
        this.paint(renderContext, mouseX, mouseY, partialTicks);
        if (this.description != null && (root = this.description.getRootPanel()) != null && (hitChild = root.hit(mouseX - this.left, mouseY - this.top)) != null) {
            hitChild.renderTooltip(renderContext, this.left, this.top, mouseX - this.left, mouseY - this.top);
        }
        VisualLogger.render(renderContext);
    }

    public void method_25393() {
        WPanel root;
        super.method_25393();
        if (this.description != null && (root = this.description.getRootPanel()) != null) {
            root.tick();
        }
    }

    public boolean method_25402(class_11909 mouseButtonEvent, boolean bl) {
        super.method_25402(mouseButtonEvent, bl);
        double mouseX = mouseButtonEvent.comp_4798();
        double mouseY = mouseButtonEvent.comp_4799();
        int mouseButton = mouseButtonEvent.method_74245();
        int containerX = (int)mouseX - this.left;
        int containerY = (int)mouseY - this.top;
        this.mouseInputHandler.checkFocus(containerX, containerY);
        if (containerX < 0 || containerY < 0 || containerX >= this.field_22789 || containerY >= this.field_22790) {
            return true;
        }
        this.mouseInputHandler.onMouseDown(containerX, containerY, mouseButton);
        return true;
    }

    public boolean method_25406(class_11909 mouseButtonEvent) {
        super.method_25406(mouseButtonEvent);
        double mouseX = mouseButtonEvent.comp_4798();
        double mouseY = mouseButtonEvent.comp_4799();
        int mouseButton = mouseButtonEvent.method_74245();
        int containerX = (int)mouseX - this.left;
        int containerY = (int)mouseY - this.top;
        this.mouseInputHandler.onMouseUp(containerX, containerY, mouseButton);
        return true;
    }

    public boolean method_25403(class_11909 mouseButtonEvent, double deltaX, double deltaY) {
        super.method_25403(mouseButtonEvent, deltaX, deltaY);
        double mouseX = mouseButtonEvent.comp_4798();
        double mouseY = mouseButtonEvent.comp_4799();
        int mouseButton = mouseButtonEvent.method_74245();
        int containerX = (int)mouseX - this.left;
        int containerY = (int)mouseY - this.top;
        this.mouseInputHandler.onMouseDrag(containerX, containerY, mouseButton, deltaX, deltaY);
        return true;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
        int containerX = (int)mouseX - this.left;
        int containerY = (int)mouseY - this.top;
        this.mouseInputHandler.onMouseScroll(containerX, containerY, horizontalAmount, verticalAmount);
        return true;
    }

    public void method_16014(double mouseX, double mouseY) {
        super.method_16014(mouseX, mouseY);
        int containerX = (int)mouseX - this.left;
        int containerY = (int)mouseY - this.top;
        this.mouseInputHandler.onMouseMove(containerX, containerY);
    }

    public boolean method_25400(class_11905 characterEvent) {
        char ch = characterEvent.method_74226().charAt(0);
        int keyCode = characterEvent.comp_4793();
        WWidget focus = this.description.getFocus();
        if (focus != null && focus.onCharTyped(ch) == InputResult.PROCESSED) {
            return true;
        }
        return super.method_25400(characterEvent);
    }

    public boolean method_25404(class_11908 keyEvent) {
        char ch = (char)keyEvent.comp_4795();
        int keyCode = keyEvent.comp_4795();
        int modifiers = keyEvent.comp_4797();
        WWidget focus = this.description.getFocus();
        if (focus != null && focus.onKeyPressed(ch, keyCode, modifiers) == InputResult.PROCESSED) {
            return true;
        }
        return super.method_25404(keyEvent);
    }

    public boolean method_16803(class_11908 keyEvent) {
        char ch = (char)keyEvent.comp_4795();
        int keyCode = keyEvent.comp_4795();
        int modifiers = keyEvent.comp_4797();
        WWidget focus = this.description.getFocus();
        if (focus != null && focus.onKeyReleased(ch, keyCode, modifiers) == InputResult.PROCESSED) {
            return true;
        }
        return super.method_16803(keyEvent);
    }

    protected void method_37056(class_6382 builder) {
        if (this.description != null) {
            NarrationHelper.addNarrations(this.description.getRootPanel(), builder);
        }
    }
}

